/*:
 * @target MZ
 * @plugindesc 左上に2つの変数を表示し、ラベルはコード内で設定。スイッチで表示ON/OFFを切替可能。
 * @author ChatGPT
 *
 * @param Variable1ID
 * @text 変数1のID
 * @type variable
 * @default 1
 *
 * @param Variable2ID
 * @text 変数2のID
 * @type variable
 * @default 2
 *
 * @param ControlSwitchID
 * @text 表示制御用スイッチID
 * @desc このスイッチがONのときのみウィンドウを表示
 * @type switch
 * @default 1
 *
 * @param FontSize
 * @text フォントサイズ
 * @type number
 * @default 20
 *
 * @param X
 * @text 表示X座標
 * @type number
 * @default 10
 *
 * @param Y
 * @text 表示Y座標
 * @type number
 * @default 10
 *
 * @param LineHeight
 * @text 行の間隔
 * @type number
 * @default 24
 *
 * @help
 * ■このプラグインについて
 * マップ画面の左上に、指定した2つの変数の値を表示します。
 * 表示されるラベルはプラグインコード内で編集してください。
 * 指定したスイッチがONのときだけ表示されます。
 *
 * ■ラベルの編集方法
 * コード内の以下部分を修正してください：
 * const label1 = "HP";
 * const label2 = "MP";
 *
 * ■利用許可
 * 商用・非商用問わず使用可能。クレジット表記は任意です。
 */

(() => {
  const parameters = PluginManager.parameters("ShowTwoVariablesWithLabelsSwitchControl");
  const var1 = Number(parameters["Variable1ID"] || 1);
  const var2 = Number(parameters["Variable2ID"] || 2);
  const controlSwitch = Number(parameters["ControlSwitchID"] || 1);
  const fontSize = Number(parameters["FontSize"] || 20);
  const posX = Number(parameters["X"] || 10);
  const posY = Number(parameters["Y"] || 10);
  const lineHeight = Number(parameters["LineHeight"] || 24);

  // ↓↓↓ ここでラベルの内容を自由に変更できます ↓↓↓
  const label1 = "DAY";
  const label2 = "成長までの残り回数：";
  // ↑↑↑ ここを編集すれば表示内容が変わります ↑↑↑

  class Window_VariableDisplay extends Window_Base {
    initialize() {
      const width = 240;
      const height = this.fittingHeight(2);
      super.initialize(new Rectangle(posX, posY, width, height));
      this.refresh();
      this._refreshCounter = 0;
      this.visible = false;
    }

    update() {
      super.update();
      this._refreshCounter++;
      if (this._refreshCounter % 30 === 0) {
        this.refresh();
      }

      // スイッチによる表示切り替え
      this.visible = $gameSwitches.value(controlSwitch);
    }

    refresh() {
      this.contents.clear();
      this.contents.fontSize = fontSize;
      const value1 = $gameVariables.value(var1);
      const value2 = $gameVariables.value(var2);
      this.drawText(`${label1}: ${value1}`, 0, 0, this.contentsWidth(), "left");
      this.drawText(`${label2}: ${value2}`, 0, lineHeight, this.contentsWidth(), "left");
    }
  }

  const _Scene_Map_start = Scene_Map.prototype.start;
  Scene_Map.prototype.start = function () {
    _Scene_Map_start.call(this);
    this._variableWindow = new Window_VariableDisplay();
    this.addWindow(this._variableWindow);
  };
})();
